<?php

require_once("templating/template.php");

function createpage ($pagename){
     
     /*Inicializations*/
     $page = new Page("templating/template.html");
     $file_prefix = 'text/'.$pagename.'_';
     $column_number = get_column_number ($file_prefix); /* Could be 1 or 4*/

     /*Includes a one-column or four-column in the web template*/
     $layout = get_layout($column_number);
     $page->replace_tags(array(
         "textlayout" => $layout,
     ));

    /*Retrieves the contents for the appropiate files*/
    $column1 =  get_include_contents($file_prefix.'column1.html');     
    if ($column_number = 4){
          $column2 =  get_include_contents($file_prefix.'column2.html');
          $column3 =  get_include_contents($file_prefix.'column3.html');
          $column4 =  get_include_contents($file_prefix.'column4.html');
    }

    /*Replaces the contents in the web template to get the webpage */
    if ($column_number == 1){ 
         $page->replace_tags(array("column1" => $column1,));
    } else{
         $page->replace_tags(array(
              "column1" => $column1,
              "column2" => $column2,
              "column3" => $column3,
              "column4" => $column4,
         ));
    }
    
    /* Outputs the Web page*/
    $page->output();
}

/** AUXILIARY FUNCTIONS **/
 
/* Returns the contents of a file */
function get_include_contents($filename) {
    if (is_file($filename)) {
        ob_start();
        include $filename;
        $contents = ob_get_contents();
        ob_end_clean();
        return $contents;
    }
    return false;
}

/* Returns the number of columns of the web page */
function get_column_number($file_prefix){
    if (file_exists($file_prefix.'column4.html')) { 
        return 4;
    } else {
        return 1;
    }
}

/* Returns the appropiate layout with the appropiate number of columns*/
function get_layout($column_number){
    if ($column_number==4) { 
        return get_include_contents("templating/fourcolumnlayout.html");
    } else {
        return get_include_contents("templating/onecolumnlayout.html");
    }
}

?>

